-- Adds functions in radio menu F10
--Script attached to mission and executed via trigger
--Functions accessed via LUA Run Script
------------------------------------------------------------------------------------------------------- 
--player can request emergency resupply with S-3B's
-- It is possible to send the whole PACK in RTB to avoid unnecessary losses. 
------------------------------------------------------------------------------------------------------- 
-- Miguel Fichier Revision debug_ADD_CRF10.c
------------------------------------------------------------------------------------------------------- 

-- debug_ADD_CRF10.c	n'affiche pas les messages d'error sauf à la fin de mission
-- Miguel21 modification M36	Help CAP 
-- Miguel21 modification M32	E-2C automatic retreat 
-- Miguel21 modification M29.e	MenuRadio CallTankRefuel

if not camp.debug then 
	env.setErrorMessageBoxEnabled(false)
end


local commandDB = {}

tabBingoPlane = {}
	
	
	
 function _affiche(_table, titre, prof)


	--export custom mission log
	local logExp = "logExp  " 
		
 if not prof or prof == nil then prof = 999 end 						-- prof = profondeur de niveau dans la hierarchie
  logExp = logExp.."\n"
  
    if titre == nil then logExp = logExp.. string.format(" _affiche() titre = nil ")
    elseif type( titre) == "string" then
		logExp = logExp.. string.format(" _affiche(titre) "..tostring(titre)).."\n"
	end
  
	if type( _table) == "table"  then --and  (table.getn(_table) ~= 0 or table.getn(_table) ~= nil
	
		for a, b in pairs(_table) do --for a, b in pairs(event.initiator) do --for a, b in pairs(_ammo) do
			-- logExp.. " _affiche( a  ) ".. tostring(a).."\n"  
		
			if  type(b) ~= "table" then
				logExp = logExp.." _affiche (a b)     "..tostring(a).." "..tostring(b).."\n"
			elseif type(b) == "table"   and prof >= 2 then
				for c, d in pairs(b) do
					logExp = logExp.. " _affiche(a c)           "..tostring(a).." "..tostring(c).."\n"
					
					
					if type(d)~= "table"  then
						logExp = logExp.. " _affiche(d)                "..tostring(d).."\n"
					elseif type(d) == "table"  and prof >= 3 then
						for e, f in pairs(d) do
							-- logExp = logExp.. " _affiche( e)                     "..tostring(e).."\n"
							
							
							if type( f ) ~= "table"  then
								logExp = logExp.. " _affiche(e f)                          "..tostring(e).." "..tostring(f).."\n"
							elseif type( f ) == "table"  and prof >= 4 then
								logExp = logExp.. " _affiche( e)                                "..tostring(e).."\n"
								for g, h in pairs(f) do
									logExp = logExp.. " _affiche(Ig)                                 "..tostring(g).."\n"
									
									
									if type( h ) ~= "table"  then
										logExp = logExp.. " _affiche(g h)                                    "..tostring(g).." "..tostring(h).."\n"	
									elseif type( h ) == "table"  and prof >= 5 then
										logExp = logExp.. " _affiche( g)                                         "..tostring(g).."\n"
										for i, j in pairs(h) do
											-- logExp = logExp.. " _affiche(i)                                         "..tostring(i).."\n"
										
										
											if type( j ) ~= "table"  then
												logExp = logExp.. " _affiche(i j)                                              "..tostring(i).." "..tostring(j).."\n"
											elseif type( j ) == "table" and prof >= 6 then									
												logExp = logExp.. " _affiche(i)                                                  "..tostring(i).."\n"
												for k, l in pairs(j) do
													-- logExp = logExp.. " _affiche(k)                                                   "..tostring(k).."\n"
													
													if type( l ) ~= "table"  then
														logExp = logExp.. " _affiche(k l)                                                   "..tostring(k).." "..tostring(l).."\n"
													elseif type( l ) == "table" and prof >= 7 then
														logExp = logExp.. " _affiche(k)                                                       "..tostring(k).."\n"
														for m, n in pairs(l) do
															logExp = logExp.. " _affiche(m)                                                        "..tostring(m).."\n"
														
														
															if type( n ) ~= "table"  then
																logExp = logExp.. " _affiche(m n)                                                   "..tostring(m).." "..tostring(n).."\n"
															elseif type( n ) == "table" and prof >= 7 then
																logExp = logExp.. " _affiche(m)                                                       "..tostring(m).."\n"
																for o, p in pairs(n) do
																	logExp = logExp.. " _affiche(o)                                                        "..tostring(o).."\n"
														
														
																	if type( p ) ~= "table"  then
																		logExp = logExp.. " _affiche(p)                                                             "..tostring(p).."\n"
																	elseif type( p ) == "table"  and prof >= 8 then
																		logExp = logExp.. " p est une table                                                              "..tostring(p).."---------------------------".."\n"
																			
																	end
																end
															end --if
														end --for l
													end --if
												end -- for j
											end --if
										end -- for h
									end --if
								end --for f
							end --elseif
						end -- for d
					end -- if d
				end -- for v
			end -- if v
		end  -- for _table
	
	else logExp = logExp.. "_affiche NoTable==> " ..tostring(_table).."\n"
	
	end -- if if type( _table) == "table"

	
	-- log.write('MIGUEL.EXPORT',log.INFO,logExp)
	
	env.info( logExp )
	
end -- function affiche
  
--function to return a new point offset from an initial point
function GetOffsetPointIM(point, heading, distance)
	return {
		x = point.x + math.cos(math.rad(heading)) * distance,
		y = point.y + math.sin(math.rad(heading)) * distance
	}
end
--function to return heading between two vector2 points
function GetHeadingIM(p1, p2)
 
	local deltax = p2.x - p1.x
	local deltay = p2.y - p1.y
	if (deltax > 0) and (deltay == 0) then
		return 0
	elseif (deltax > 0) and (deltay > 0) then
		return math.deg(math.atan(deltay / deltax))
	elseif (deltax == 0) and (deltay > 0) then
		return 90
	elseif (deltax < 0) and (deltay > 0) then
		return 90 - math.deg(math.atan(deltax / deltay))
	elseif (deltax < 0) and (deltay == 0) then
		return 180
	elseif (deltax < 0) and (deltay < 0) then
		return 180 + math.deg(math.atan(deltay / deltax))
	elseif (deltax == 0) and (deltay < 0) then
		return 270
	elseif (deltax > 0) and (deltay < 0) then
		return 270 - math.deg(math.atan(deltax / deltay))
	else
		return 0
	end
end

function FctRemovePlane(_unit)
	_unit:destroy()
end

function RemovePlane(PlayerGroup)

	local PlayerUnits = PlayerGroup:getUnits()
	local PlayerUnit = PlayerUnits[1]	
	local PlayerUnitPoint = PlayerUnit:getPoint()
	local Coalition = PlayerUnit:getCoalition()
	missionCommands.removeItem( {"nearby aircraft"})
	local requestM = missionCommands.addSubMenu('nearby aircraft'  )
	local RPlane = {}
	local groups = coalition.getGroups(Coalition, Group.Category.AIRPLANE)
	for i, gp in pairs(groups) do	
		local gpName = Group.getName(gp)
		local units = gp:getUnits()
		 
		for n=1, #units do
			local _unit = units[n]
			if  _unit:isActive() and not _unit:inAir() then
				
				local description = _unit:getDesc()	
				
				_affiche(description, "description")
				
				local unitPos = _unit:getPoint()
				local  gpGid = Group.getID(gp)
				local  UnitId = Unit.getID(_unit)
				local unitCallsign = _unit:getCallsign()
				local distance = math.floor(math.sqrt(math.pow(unitPos.x - PlayerUnitPoint.x, 2) + math.pow(unitPos.z - PlayerUnitPoint.z, 2)))
				if distance <= 900 then
					env.info(gpName.." "..unitCallsign.." "..distance.."m ")
					-- trigger.action.outText(gpName.." "..unitCallsign.." "..distance.."m ", 15)	--FOR DEBUG
					-- local subN1 = missionCommands.addSubMenu(gpName.." "..UnitId, requestM)
					RPlane[UnitId] = missionCommands.addCommand(gpName.." "..unitCallsign, requestM, FctRemovePlane, _unit)
				end
			end
		end
	end
end


-- Miguel21 modification M32	E-2C automatic retreat 
function AirRetreat()
	
	local current_time = timer.getTime()
	
	local groups = coalition.getGroups(coalition.side.BLUE, Group.Category.AIRPLANE)
	
	for i, gp in pairs(groups) do	
	
		local gpName = Group.getName(gp)
		
		if   string.find(gpName,"AWACS") then 
			env.info("ACRF10 Trouve AWACS ")
			local units = gp:getUnits()
			local _unit = units[1]
	
			if _unit:getTypeName() == "E-2C" and _unit:isActive() and _unit:inAir() then
				env.info("ACRF10 Trouve E2C ")
				local awacs_point = _unit:getPoint()
				local  gpGid = Group.getID(gp)
				if not RetreatTimeGp then RetreatTimeGp = {} end
				if not RetreatTimeGp[gpGid] then RetreatTimeGp[gpGid] = {} end
				if not RetreatTimeGp[gpGid].rTime then RetreatTimeGp[gpGid].rTime = 0  end
				
				if _unit and current_time >  RetreatTimeGp[gpGid].rTime then																			--if _unit exists
					env.info("ACRF10 est un _UNIT ")
					local ctr = _unit:getGroup():getController()										--get _unit controller
					local targets = ctr:getDetectedTargets()											--get detected targets of this EWR
					for t = 1, #targets do																--iterate through detected targets
						if targets[t].object then
							local objCat = targets[t].object:getCategory()								--get object category
							if objCat == 1 then															--object is a _unit
								local desc = targets[t].object:getDesc()								--get descriptor descriptor
								if desc.category == 0  then												--descriptor category is airplane 
									local target_point = targets[t].object:getPoint()					--get target point
					
									local distance = math.sqrt(math.pow(awacs_point.x - target_point.x, 2) + math.pow(awacs_point.z - target_point.z, 2))
									
									if distance < 80000 then
									
										env.info("ACRF10 DCE AWAC: Order to Retire "..distance)
										--active le waypoint du PA
										
										 RetreatTimeGp[gpGid].rTime = current_time + 1240

										for _coalition, coalition in pairs(env.mission.coalition) do
											if _coalition == camp.player.side then
												for Ncountry, _country in pairs(coalition.country) do	
													if _country.plane then
														for Ngroup, _group in pairs(_country.plane.group) do
															if _group.groupId == gpGid then 				
																
																for key, value in ipairs(_group.route.points) do				-- recherche de la position safe du PA et une alti						
																	if value.type == 'Land' then
																		local xRetreat = value.x
																		local yRetreat = value.y
																	elseif value.type == 'Station' then
																		local altRetreat = value.alt
																	end
																end
																
																local retreatRoute = {}
																
																retreatRoute = _group.route										--copie de l'ancienne route
																
																for key, value in ipairs(retreatRoute) do						
																	if key == 1 then
																		retreatRoute[key].x = xRetreat
																		retreatRoute[key].y = yRetreat
																		retreatRoute[key].alt = altRetreat
																		retreatRoute[key].speed_locked = true
																		retreatRoute[key].speed = 200
																		
																		local idTasks = #retreatRoute[key].task.params.tasks
																		local orbitRetreat = {
																								[idTasks+1] = {
																									['enabled'] = true,
																									['auto'] = false,
																									['id'] = 'ControlledTask',
																									['number'] = idTasks+1,
																									['params'] = {
																										['task'] = {
																											['id'] = 'Orbit',
																											['params'] = {
																												['altitude'] = 7315.2,
																												['pattern'] = 'Race-Track',
																												['speed'] = 138.889,
																											},
																										},
																										['stopCondition'] = {
																											['time'] = 1000,
																										},
																									},
																								},
																							}

																		-- table.insert(retreatRoute[key].task.params.tasks, orbitRetreat)
																		
																		retreatRoute[key].task.params.tasks[idTasks +1] =  orbitRetreat

																		
																	end
																end
															end
														end
													end
												end
											end
										end

										local Mission = {														--define mission for retreat AWACS
												id = 'Mission', 
												params = {
													route = {
														retreatRoute
													},
												}
											}
										
										Controller.setTask(ctr, Mission)										--activate task with mission for retreat AWACS
									
									end
								end
							end
						end
					end
				end
			end
		end
	end
end

function bingo(gpGid, PlayerGroup)

	for index, data in pairs(PlayerGroup:getUnits()) do
		
		local callSign = Unit.getCallsign(data)
		
		if not tabBingoPlane[gpGid] then tabBingoPlane[gpGid] = {} end
		
		if tabBingoPlane[gpGid] and not tabBingoPlane[gpGid][callSign] then												-- si le callSign a deja dit qu'il etait Bingo, on l'oublie
		
			if Unit.getFuel(data) <  0.25 then																			-- Sur F14, 4000lbs/16000lbs = 0.25%

				trigger.action.outTextForGroup(gpGid, callSign .." Bingo Fuel", 15 , true)
				env.info( " Unit.getFuel(data)  "..callSign )
			
				tabBingoPlane[gpGid][callSign] = true																	-- la callSign � d�ja indiqu� qu'il �tait Bingo
			
			end 
		end
	end
end

function TestOLD(PlayerGroup)

	local PlayerUnits = PlayerGroup:getUnits()
	local PlayerUnit = PlayerUnits[1]
	local fuel = PlayerUnit:getFuel()	
	
	-- fichier miz:
		-- plan haut, droite, alti : x/y/z
	-- vue F10 et vector3d:
		-- plan haut, droite, alti : x/z/y
	
	local t_speed = PlayerUnit:getVelocity()
	speed = math.sqrt(t_speed.x^2 + t_speed.y^2 + t_speed.z^2)
	
	trigger.action.outText("RR speed "..speed.." m/s || "..(speed *3.6).." km/h ||| fuel: "..fuel, 15)	--FOR DEBUG
	-- env.info("RR speed "..speed.." m/s || "..(speed *3.6).." km/h ||| fuel: "..fuel)
	
	if  PlayerUnits[2]	then
	
		local PlayerUnit2 = PlayerUnits[2]
		local t_speed = PlayerUnit2:getVelocity()
		speed = math.sqrt(t_speed.x^2 + t_speed.y^2 + t_speed.z^2)
	
		trigger.action.outText("RR speed PlayerUnits[2] "..speed.." m/s || "..(speed *3.6).." km/h ||| fuel: "..fuel, 15)	--FOR DEBUG
		-- env.info("RR speed PlayerUnits[2] "..speed.." m/s || "..(speed *3.6).." km/h ||| fuel: "..fuel)
	
	end

	trigger.action.outText("ACRF10 mission.date.Year "..env.mission.date.Year.." || "..env.mission.date.Day.."|| "..env.mission.date.Month, 15)	--FOR DEBUG
	-- env.info("ACRF10 mission.date.Year "..env.mission.date.Year.." || "..env.mission.date.Day.."|| "..env.mission.date.Month)
	
end


LLtool = {}

LLtool.LLstrings = function(pos) -- pos is a Vec3

	local LLposN, LLposE = coord.LOtoLL(pos)
	local LLposfixN, LLposdegN = math.modf(LLposN)
	LLposdegN = LLposdegN * 60
	local LLposdegN2, LLposdegN3 = math.modf(LLposdegN)
	LLposdegN3 = LLposdegN3 * 1000

	local LLposfixE, LLposdegE = math.modf(LLposE)
	LLposdegE = LLposdegE * 60
	local LLposdegE2, LLposdegE3 = math.modf(LLposdegE)
	LLposdegE3 = LLposdegE3 * 1000

	local LLposNstring = string.format('%+.2i %.2i %.3d', LLposfixN, LLposdegN2, LLposdegN3)
	local LLposEstring = string.format('%+.3i %.2i %.3d', LLposfixE, LLposdegE2, LLposdegE3)
	
	return LLposNstring, LLposEstring
end


function BullsEye(PlayerGroup)

			-- ['coalition'] = {
					-- ['blue'] = {
						-- ['bullseye'] = {
							-- ['y'] = 635639.37385346,
							-- ['x'] = -317948.32727306,
						-- },
	local gpGid = PlayerGroup:getID()
	local PlayerUnits = PlayerGroup:getUnits()
	local PlayerUnit = PlayerUnits[1]
	
	local Coalition = PlayerUnit:getCoalition()
	
	sideT = {
		[0] = "neutral",
		[1] = "red",
		[2] = "blue"
		}
	
	local bullsEye_pos = {
							x = env.mission.coalition[sideT[Coalition]].bullseye.x,
							y = 0,
							z = env.mission.coalition[sideT[Coalition]].bullseye.y
					}

	LLposNstring, LLposEstring = LLtool.LLstrings(bullsEye_pos)    

	trigger.action.outTextForGroup(gpGid, "BullsEye: "..'N ' .. LLposNstring .. '   E ' .. LLposEstring, 45 , true)

end

function FctRtbGroup(rtbGroup)

	trigger.action.outText("RTB "..tostring(rtbGroup.name), 5)	--FOR DEBUG
	
	local gp = Group.getByName(rtbGroup.name) 

	local rtbCtr = Group.getController(gp)


		local switchtask = { 
							id = "SwitchWaypoint", 
							params = { 
							goToWaypointIndex = rtbGroup.to,
							fromWaypointIndex = rtbGroup.from
						}
					}

		rtbCtr:setCommand(switchtask)
		
end



function RtbPack(PlayerGroup)

	for _coalition, coalition in pairs(env.mission.coalition) do
		if _coalition == camp.player.side then
			for Ncountry, _country in pairs(coalition.country) do	
				if _country.plane then
					for Ngroup, _group in pairs(_country.plane.group) do
						if string.find(_group.name,"Pack "..camp.player.pack_n) then 				
							
							local rtbGroup = {
											name = "",
											from = 0,
											to = 0
											}
							
							
							rtbGroup.name = _group.name
							
							for key, value in ipairs(_group.route.points) do						
								if value.type == 'Land' then
									rtbGroup.to = key -1
									rtbGroup.from = key
								end

							end
						
							if rtbGroup.name and rtbGroup.to ~= 0 then
								FctRtbGroup(rtbGroup)
							end
							
						end
					end
				end
			end
		end
	end
end

function ReFueling(PlayerGroup)
	
	local player = {
		["point"] = {}
	}

	local tanker = {
		["point"] = {},
		["name"] = "",
		["distance"] = 0, 
		["gpName"] = ""
	}
	
	local PlayerUnits = PlayerGroup:getUnits()
	local PlayerUnit = PlayerUnits[1]	
	local uid = PlayerUnit:getID()
	
	-- fichier miz:
		-- plan haut, droite, alti : x/y/z
	-- vue F10 et vector3d:
		-- plan haut, droite, alti : x/z/y
		
	local PtempPoint = PlayerUnit:getPoint()											
			player.point.x = PtempPoint.x
			player.point.y = PtempPoint.z
			player.point.z = PtempPoint.y
	
	local speed = PlayerUnit:getVelocity()
	player.speed = math.sqrt(speed.x^2 + speed.y^2 + speed.z^2)
	local groups = coalition.getGroups(coalition.side.BLUE, Group.Category.AIRPLANE)
	local selected_distance = 99999999
	
	for i, gp in pairs(groups) do
		
		local gpName = Group.getName(gp)
		
		if   string.find(gpName,"Refueling") then 
			local units = gp:getUnits()
			local _unit = units[1]
			local fuel = _unit:getFuel()
			local callsign = _unit:getCallsign()
			local TankerTypeName = _unit:getTypeName()
			local t = {
						["point"] = {}
						}
						
			local TtempPoint = _unit:getPoint()
					t.point.x = TtempPoint.x
					t.point.y = TtempPoint.z
					t.point.z = TtempPoint.y
	
			if _unit:getTypeName() == "S-3B Tanker" and _unit:isActive() then	
			-- if _unit:getTypeName() == "S-3B Tanker"  and t.point.z > 100 and _unit:isActive() then			
				
				local Tdistance = math.sqrt(math.pow(t.point.x - player.point.x, 2) + math.pow(t.point.y - player.point.y, 2))		--distance between tanker and player

				if Tdistance < selected_distance then

					tanker.point = t.point
					tanker.TypeName = TankerTypeName
					tanker.distance = Tdistance
					tanker.gpName = tostring(gpName)
					tanker.ctr = Group.getController(gp)
					tanker.callsign = callsign
					tanker._unit = _unit
					tanker.Desc = _unit:getDesc()
					selected_distance =  Tdistance
					
				end
			end
		end
	end

	local heading  = GetHeadingIM(tanker.point, player.point)		--return heading between two vector2 points

	local dist = tanker.distance / 2

	local interception_pos = GetOffsetPointIM(tanker.point, heading, dist)		--function to return a new point offset from an initial point

	local interception_alt = player.point.z 
	local pattern_alt = player.point.z 
	
	local pattern_speed = player.speed
	
	if interception_alt < 1000 and dist > 50000 then
		interception_alt = 3000
	elseif interception_alt > 6100  then										-- alti max:6100
		interception_alt = 6100
		pattern_alt = 6100
	end	
	
	if pattern_speed < 130  then
		pattern_speed = 130
	elseif pattern_speed > 200  then											-- vi max:6100
		pattern_speed = 200
	end	
	
	local infoSpeed = math.floor(pattern_speed / 0.51444444444)					-- m/s to Kts
	local infoAlti = math.floor((pattern_alt * 3.2808398950131 )/100)*100		-- m to ft
	
	local intercept_pos = {
					x = interception_pos.x,
					y = pattern_alt,
					z = interception_pos.y
					}
					
	local intercept_LL =  coord.LOtoLL(intercept_pos)
	
	LLposNstring, LLposEstring = LLtool.LLstrings(intercept_pos)

	trigger.action.outText(tanker.callsign.." "..tanker.gpName.." Rdv: "..'N ' .. LLposNstring .. '   E ' .. LLposEstring.." Alt: "..infoAlti.." Speed "..infoSpeed, 20)
	
	
		local Mission = {														--define mission for interceptor group
			id = 'Mission', 
			params = {
				route = {
					["points"] = {
						[1] = {
							["alt"] = interception_alt,
							["type"] = "Turning Point",
							["action"] = "Turning Point",
							["alt_type"] = "BARO",
							["formation_template"] = "",
							["y"] = interception_pos.y ,
							["x"] = interception_pos.x ,
							["speed"] = 200,
							["ETA_locked"] = false,
							["task"] = {
								["id"] = "ComboTask",
								["params"] = 
								{
									["tasks"] = 
									{
									
										[1] = 
										{
											["number"] = 1,
											["auto"] = false,
											["id"] = "Tanker",
											["enabled"] = true,
											["params"] = 
											{
											}, -- end of ["params"]
										}, -- end of [1]
										[2] = 
										{
											["number"] = 2,
											["auto"] = false,
											["id"] = "ControlledTask",
											["enabled"] = true,
											["params"] = 
											{
												["task"] = 
												{
													["id"] = "Orbit",
													["params"] = 
													{
														["altitude"] = pattern_alt,
														["pattern"] = "Circle",
														["speed"] = pattern_speed,
														["speedEdited"] = true,
													}, -- end of ["params"]
												}, -- end of ["task"]
												["stopCondition"] = 
												{
													["duration"] = 600,
												}, -- end of ["stopCondition"]
											}, -- end of ["params"]
										}, -- end of [2]
									}, -- end of ["tasks"]
								}, -- end of ["params"]
							},
							["speed_locked"] = true,
						},
						[2] = {
							["alt"] = tanker.point.z,
							["type"] = "Turning Point",
							["action"] = "Turning Point",
							["alt_type"] = "BARO",
							["formation_template"] = "",
							-- ["ETA"] = 0,
							["y"] = tanker.point.y,
							["x"] = tanker.point.x,
							["speed"] = 180,
							["ETA_locked"] = false,
							["task"] = {
								["id"] = "ComboTask",
								["params"] = {
									["tasks"] = {
									},
								},
							},
							["speed_locked"] = true,
						},
					},
				}
			}
		}--local Mission = {	
	
	
		Controller.setTask(tanker.ctr, Mission)																			--activate task with mission for interceptor group

		-- trigger.action.outText("RR PasseFinReFueling ", 15)	--FOR DEBUG
		-- env.info("RR PasseFinReFueling --")
							
end

function RequestCAP(PlayerGroup)
	-- Miguel21 modification M36	Help CAP 
	local player = {
		["point"] = {}
	}

	local CAP = {
		["point"] = {},
		["name"] = "",
		["distance"] = 0, 
		["gpName"] = ""
	}
	
	local PlayerUnits = PlayerGroup:getUnits()
	local PlayerUnit = PlayerUnits[1]	
	local uid = PlayerUnit:getID()
	
	-- fichier miz:
		-- plan haut, droite, alti : x/y/z
	-- vue F10 et vector3d:
		-- plan haut, droite, alti : x/z/y
		
	local PtempPoint = PlayerUnit:getPoint()											
			player.point.x = PtempPoint.x
			player.point.y = PtempPoint.z
			player.point.z = PtempPoint.y
	
	local speed = PlayerUnit:getVelocity()
	player.speed = math.sqrt(speed.x^2 + speed.y^2 + speed.z^2)
	local groups = coalition.getGroups(coalition.side.BLUE, Group.Category.AIRPLANE)
	local selected_distance = 99999999
	
	for i, gp in pairs(groups) do
		
		local gpName = Group.getName(gp)
		
		if   string.find(gpName,"CAP") then 
			local units = gp:getUnits()
			local _unit = units[1]
			local fuel = _unit:getFuel()
			local callsign = _unit:getCallsign()
			local TankerTypeName = _unit:getTypeName()
			local t = {
						["point"] = {}
						}
						
			local TtempPoint = _unit:getPoint()
					t.point.x = TtempPoint.x
					t.point.y = TtempPoint.z
					t.point.z = TtempPoint.y
	
			if  _unit:isActive() then	
			-- if _unit:getTypeName() == "S-3B Tanker"  and t.point.z > 100 and _unit:isActive() then			
				
				local Tdistance = math.sqrt(math.pow(t.point.x - player.point.x, 2) + math.pow(t.point.y - player.point.y, 2))		--distance between tanker and player

				if Tdistance < selected_distance then

					CAP.point = t.point
					CAP.TypeName = TankerTypeName
					CAP.distance = Tdistance
					CAP.gpName = tostring(gpName)
					CAP.ctr = Group.getController(gp)
					CAP.callsign = callsign
					CAP._unit = _unit
					CAP.Desc = _unit:getDesc()
					selected_distance =  Tdistance
					
				end
			end
		end
	end
--[[	
	local  gpGid = Group.getID(gp)
	
	for _coalition, coalition in pairs(env.mission.coalition) do
		if _coalition == camp.player.side then
			for Ncountry, _country in pairs(coalition.country) do	
				if _country.plane then
					for Ngroup, _group in pairs(_country.plane.group) do
						if _group.groupId == gpGid then 				
							
							frequencyCAP = _group.frequency	
								
						end
					end
				end
			end
		end
	end
]]

--[[
export in low tick interval to Ikarus
Example from A-10C
Get Radio Frequencies
get data from device
local lUHFRadio = GetDevice(54)
ExportScript.Tools.SendData("ExportID", "Format")
ExportScript.Tools.SendData(2000, string.format("%7.3f", lUHFRadio:get frequency()/1000000)) <- special function for get frequency data
]]


	local heading  = GetHeadingIM(CAP.point, player.point)					--return heading between two vector2 points
	local dist = CAP.distance / 1.5											-- approche le CAP 
	
	CAP.velocity = CAP._unit:getVelocity() 
	CAP.speed = math.sqrt(CAP.velocity.x^2 + CAP.velocity.y^2 + CAP.velocity.z^2)
	
	local interception_pos = GetOffsetPointIM(CAP.point, heading, dist)		--function to return a new point offset from an initial point

	local interception_alt = player.point.z 
	local pattern_speed 													-- ex = player.speed
	
	if interception_alt < 3000 and dist > 50000 then
		interception_alt = 7600
	elseif interception_alt > 6100  then										-- alti max:6100
		interception_alt = 7600		
	end	

	trigger.action.outText(CAP.callsign.." "..CAP.gpName, 20)
	
	
		local Mission = {														--define mission for interceptor group
			id = 'Mission', 
			params = {
				route = {
					["points"] = {
						
						[1] = {
							['alt'] = interception_alt,
							['briefing_name'] = 'Station',
							['action'] = 'Turning Point',
							['alt_type'] = 'BARO',
							['properties'] = {
								['vnav'] = 1,
								['scale'] = 0,
								['angle'] = 0,
								['vangle'] = 0,
								['steer'] = 2,
							},
							['speed_locked'] = true,
							['speed'] = 290,									-- vitesse du son  295 a 20000m
							['ETA'] = 1,
							["y"] = interception_pos.y ,
							["x"] = interception_pos.x ,
							['formation_template'] = '',
							['name'] = 'Station',
							['ETA_locked'] = false,
							['task'] = {
								['id'] = 'ComboTask',
								['params'] = {
									['tasks'] = {
										[1] = {
											['enabled'] = true,
											['auto'] = false,
											['id'] = 'ControlledTask',
											['number'] = 1,
											['params'] = {
												['task'] = {
													['id'] = 'EngageTargetsInZone',
													['params'] = {
														['targetTypes'] = {
															[1] = 'Air',
															[2] = 'Cruise missiles',
														},
														['x'] = player.point.x,
														['value'] = 'Air;Cruise missiles;',
														['priority'] = 0,
														['y'] = player.point.y,
														['zoneRadius'] = 111000,
													},
												},
												['stopCondition'] = {
													['lastWaypoint'] = 3,
												},
											},
										},
										[2] = {
											['enabled'] = true,
											['auto'] = false,
											['id'] = 'ControlledTask',
											['number'] = 2,
											['params'] = {
												['task'] = {
													['id'] = 'Orbit',
													['params'] = {
														['altitude'] = CAP.point.z,
														['pattern'] = 'Race-Track',
														['speed'] = CAP.speed,
													},
												},
												['stopCondition'] = {
													['time'] = 1000,
												},
											},
										},
									},
								},
							},
							['type'] = 'Turning Point',
						},
					},
				}
			}
		}--local Mission = {	
	
	
		Controller.setTask(CAP.ctr, Mission)																			--activate task with mission for interceptor group
		
		trigger.action.outText("ADD_CR "..CAP.callsign.." "..CAP.gpName, 60)
end


function addFuncs(gid, Group)
	
	if gid and Group then
		
		-- supprime les anciens items de la commande F10
		missionCommands.removeItemForGroup(gid, {"Urgent_Refueling"})
		missionCommands.removeItemForGroup(gid, {"Urgent_RequestCAP"})
		missionCommands.removeItemForGroup(gid, {"BullsEye_LongLat"})	
		missionCommands.removeItemForGroup(gid, {"Package_RTB"})
		missionCommands.removeItemForGroup(gid, {"RemovePlane"})		

		missionCommands.addCommandForGroup(gid, "Urgent_Refueling", nil, ReFueling, Group)
		missionCommands.addCommandForGroup(gid, "Urgent_RequestCAP", nil, RequestCAP, Group)
		missionCommands.addCommandForGroup(gid, "BullsEye_LongLat", nil, BullsEye, Group)
		missionCommands.addCommandForGroup(gid, "Package_RTB", nil, RtbPack, Group)
		missionCommands.addCommandForGroup(gid, "RemovePlane", nil, RemovePlane, Group)		
		
		-- The solution is to use env.mission.coalition where you find all object informations even groupId
		-- https://forums.eagle.ru/showthread.php?t=147792&page=15
		
		 -- commandDB['RUR'] = missionCommands.addCommandForGroup(gid,"UrgentRefueling", nil, ReFueling, Group)
		 -- commandDB['speed'] = missionCommands.addCommandForGroup(gid,"Testing", nil, Test, Group)
		 -- commandDB['RTB'] = missionCommands.addCommandForGroup(gid,"Package_RTB", nil, RtbPack, Group)
	end
end

EventHandler2 = {}
function EventHandler2:onEvent(event)

	if event.id == world.event.S_EVENT_BIRTH then

		local Gname = event.initiator:getPlayerName()
		local Uid = event.initiator:getID()
		local Group = event.initiator:getGroup()
		local gpGid = event.initiator:getGroup():getID()

		if gpGid and Group and Gname  then 
			
			-- trigger.action.outText("RR Passe S_EVENT_BIRTH--"..tostring(Gname).." "..gpGid, 15)	--FOR DEBUG
			
			addFuncs(gpGid, Group)
		end
		
	elseif event.subPlace then 
		-- env.info("RR PasseEvent 003 subPlace")																								--debug ET01	
		
		local Gname = event.initiator:getPlayerName()
		local Uid = event.initiator:getID()
		local Group = event.initiator:getGroup()
		local gpGid = event.initiator:getGroup():getID()

		if gpGid  and Group and Gname then 			
			addFuncs(gpGid, Group)
		end
	end
	
end

world.addEventHandler(EventHandler2)



function LoopPilot()

	local groups = coalition.getGroups(coalition.side.BLUE, Group.Category.AIRPLANE)
	
	for i, gp in pairs(groups) do
		local  gpName = Group.getName(gp)
		local  gpGid = Group.getID(gp)
		
		if gpGid  and gp then 
			-- addFuncs(gpGid, gp)

			bingo(gpGid, gp)

		end
		
		
		
	end
			
	return timer.getTime() + 15

end

timer.scheduleFunction(LoopPilot, nil, timer.getTime() + 15)	

timer.scheduleFunction(AirRetreat, nil, timer.getTime() + 5)



  